<h1 class="title">Левая рекурсия (20%)</h1>
<p><b>Время: 1 сек.<br>Память: 16 Мб<br>Сложность: 20%</b></p>
<p>В теории формальных грамматик и автоматов (ТФГиА) важную роль играют так называемые контекстно-свободные грамматики (КС-грамматики). КС-грамматикой будем называть четверку, состоящую из множества N нетерминальных символов, множества T терминальных символов, множества P правил (продукций) и начального символа S, принадлежащего множеству N.</p>
<p>Каждая продукция p из P имеет форму A –> a, где A нетерминальный символ (A из N), а a – строка, состоящая из терминальных и нетерминальных символов. Процесс вывода слова начинается со строки, содержащей только начальный символ S. После этого на каждом шаге один из нетерминальных символов, входящих в текущую строку, заменяется на правую часть одной из продукций, в которой он является левой частью. Если после такой операции получается строка, содержащая только терминальные символы, то процесс вывода заканчивается.</p>
<p>Во многих теоретических задачах удобно рассматривать так называемые нормальные формы грамматик. Процесс приведения грамматики к нормальной форме часто начинается с устранения левой рекурсии. В этой задаче мы будем рассматривать только ее частный случай, называемый непосредственной левой рекурсией. Говорят, что правило вывода A –> R содержит непосредственную левую рекурсию, если первым символом строки R является A.</p>
<p>Задана КС-грамматика. Требуется найти количество правил, содержащих непосредственную левую рекурсию.</p>
<h2>Формат ввода</h2>
<p>Первая строка входного файла input.txt содержит количество n (1 ≤ n ≤ 1000) правил в грамматике. Каждая из последующих n строк содержит по одному правилу. Нетерминальные символы обозначаются заглавными буквами английского алфавита, терминальные - строчными. Левая часть продукции отделяется от правой символами –>. Правая часть продукции имеет длину от 1 до 30 символов.</p>
<h2>Формат вывода</h2>
<p>В выходной файл output.txt выведите ответ на задачу.</p>
<h3>Примеры</h3>
<table class="sample-tests">
<thead>
    <tr>
        <th>Ввод</th>
        <th>Вывод</th>
    </tr>
</thead>
<tbody>
        <tr>
            <td>3<br>
                S->Sabc<br>
                S->A<br>
                A->AA</td>
            <td>2</td>
        </tr>
    </tbody>
</table>

