<h1 class="title">Шаблон программы (30%)</h1>
<p><a href="https://acmp.ru/index.asp?main=task&id_task=838" target="_blank">Ссылка на задачу</a></p>
<p><b>Время: 1 сек.<br>Память: 16 Мб<br>Сложность: 30%</b></p>
<p>Многие команды, участвующие в командных соревнованиях по программированию, используют так называемый «шаблон программы». Он набирается в самом начале соревнования и содержит общее для всех решений - например, открытие и закрытие входных и выходных файлов.</p>
<p>Трехкратный чемпион мира по версии AMC команда Dream Team – не исключение. Во многом их успехи связаны с тем, что они очень тщательно готовятся к соревнованиям, продумывая даже очень мелкие детали. Например, перед последним финалом они во время пробного тура рассчитали, сколько джоулей энергии потратится на набор шаблона.</p>
<p>Организаторы финала использовали весьма странные клавиатуры — жесткость различных клавиш была различной. Таким образом, на нажатие разных клавиш требовалось различное количество энергии.</p>
<p>Эксперименты, проведенные командой Dream Team во время пробного тура, показали следующее. На набор строчной буквы английского алфавита требуется количество энергии, равное сумме цифр ее порядкового номера в алфавите (буквы нумеруются с единицы). На нажатие клавиши «Shift» требуется 10 джоулей энергии (таким образом набор заглавной буквы английского алфавита требует на 10 джоулей больше, чем набор соответствующей ей строчной буквы), нажатие клавиши «Пробел» требует 4 джоуля энергии. Набор цифры x требует (13 – x) джоулей энергии, набор точки – 5 джоулей, точки с запятой – 7 джоулей, запятой – 2 джоуля. Знак равенства, плюс, минус, одинарная и двойная кавычка требуют по 3 джоуля энергии. Закрывающая и открывающая круглые скобки требуют по 1 джоулю, а фигурные, квадратные и угловые (т.е. символы < и >) – по 8. При этом для всех упомянутых знаков препинания на клавиатуре, используемой на финале, существуют отдельные клавиши, и другой возможности набрать соответствующий символ нет. Нажатие клавиши «Enter» (перевод строки) оказалось настолько легким, что энергозатраты на него можно считать нулевыми.</p>
<p>Ваша задача – написать программу, которая по тексту шаблона вычислит энергозатраты на его набор.</p>
<h2>Формат ввода</h2>
<p>Входной файл input.txt содержит шаблон программы, энергетические затраты на набор которого необходимо вычислить. Он содержит только цифры, пробелы, строчные и заглавные буквы английского алфавита, точки, запятые, знаки равенства, плюсы, точки с запятыми, двойные кавычки ("), одинарные кавычки ('), закрывающие и открывающие круглые, фигурные и квадратные скобки. Его размер не превышает 20000 байт.</p>
<h2>Формат вывода</h2>
<p>В выходной файл output.txt выведите ответ на задачу.</p>
<h3>Примеры</h3>
<table class="sample-tests">
  <thead>
     <tr>
        <th>Ввод</th>
        <th>Вывод</th>
     </tr>
  </thead>
  <tbody>
     <tr>
        <td>abCD '+=1;2,3."()[]{}</td>
        <td>127</td>
     </tr>
     <tr>
        <td>program solution;<br>
            uses<br>
            &nbsp;sysutils, math;<br>
            begin<br>
            &nbsp;assign(input, '.in');<br>
            &nbsp;assign(output, '.out');<br>
            end.</td>
        <td>489</td>
     </tr>
  </tbody>
</table>